/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.ftb.data.Map;
import net.ftb.data.ModPack;
import net.ftb.data.TexturePack;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.FTBPacksPane;
import net.ftb.gui.panes.ThirdPartyPane;
import net.ftb.log.Logger;
import net.ftb.util.AppUtils;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;
import net.ftb.util.OSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModpackLoader
extends Thread {
    private ArrayList<String> xmlFiles = Lists.newArrayList();

    public ModpackLoader(ArrayList<String> xmlFiles) {
        this.xmlFiles = xmlFiles;
    }

    @Override
    public void run() {
        Benchmark.start("ModpackLoader");
        for (String xmlFile : this.xmlFiles) {
            Document doc;
            boolean privatePack = !xmlFile.equalsIgnoreCase("modpacks.xml") && !xmlFile.equalsIgnoreCase("thirdparty.xml");
            boolean isThirdParty = !xmlFile.equalsIgnoreCase("thirdparty.xml");
            File modPackFile = new File(OSUtils.getCacheStorageLocation(), "ModPacks" + File.separator + xmlFile);
            try {
                modPackFile.getParentFile().mkdirs();
                DownloadUtils.downloadToFile(new URL(DownloadUtils.getStaticCreeperhostLink(xmlFile)), modPackFile);
            }
            catch (IOException e) {
                Logger.logWarn("Failed to load modpacks, loading from backup", e);
            }
            Logger.logInfo("Loading modpack information for " + xmlFile + "...");
            InputStream modPackStream = null;
            try {
                modPackStream = new FileInputStream(modPackFile);
            }
            catch (IOException e) {
                Logger.logWarn("Failed to read modpack file - falling back to direct download", e);
            }
            if (modPackStream == null) {
                try {
                    modPackStream = new URL(DownloadUtils.getStaticCreeperhostLink(xmlFile)).openStream();
                }
                catch (IOException e) {
                    Logger.logError("Completely unable to download the modpack file - check your connection", e);
                }
            }
            if (modPackStream == null) continue;
            try {
                doc = AppUtils.getXML(modPackStream);
            }
            catch (Exception e) {
                Logger.logError("Exception reading modpack file", e);
                return;
            }
            if (doc == null) {
                Logger.logError("Error: could not load modpack data!");
                return;
            }
            NodeList modPacks = doc.getElementsByTagName("modpack");
            ArrayList<ModPack> mp = Lists.newArrayList();
            int offset = ModPack.getPackArray().isEmpty() ? 0 : ModPack.getPackArray().size();
            for (int i = 0; i < modPacks.getLength(); ++i) {
                Node modPackNode = modPacks.item(i);
                NamedNodeMap modPackAttr = modPackNode.getAttributes();
                try {
                    if (modPackAttr.getNamedItem("author") != null) {
                        isThirdParty = !modPackAttr.getNamedItem("author").getTextContent().equalsIgnoreCase("the ftb team");
                    }
                    mp.add(new ModPack(modPackAttr.getNamedItem("name").getTextContent(), modPackAttr.getNamedItem("author").getTextContent(), modPackAttr.getNamedItem("version").getTextContent(), modPackAttr.getNamedItem("logo").getTextContent(), modPackAttr.getNamedItem("url").getTextContent(), modPackAttr.getNamedItem("image").getTextContent(), modPackAttr.getNamedItem("dir").getTextContent(), modPackAttr.getNamedItem("mcVersion").getTextContent(), modPackAttr.getNamedItem("serverPack").getTextContent(), modPackAttr.getNamedItem("description") == null ? null : modPackAttr.getNamedItem("description").getTextContent().replace("\\n", "\n"), modPackAttr.getNamedItem("mods") != null ? modPackAttr.getNamedItem("mods").getTextContent() : "", modPackAttr.getNamedItem("oldVersions") != null ? modPackAttr.getNamedItem("oldVersions").getTextContent() : "", modPackAttr.getNamedItem("animation") != null ? modPackAttr.getNamedItem("animation").getTextContent() : "", modPackAttr.getNamedItem("maxPermSize") != null ? modPackAttr.getNamedItem("maxPermSize").getTextContent() : "", offset + i, isThirdParty && !privatePack ? modPackAttr.getNamedItem("private") != null : privatePack, xmlFile, modPackAttr.getNamedItem("bundledMap") != null, modPackAttr.getNamedItem("customTP") != null, modPackAttr.getNamedItem("minJRE") != null ? modPackAttr.getNamedItem("minJRE").getTextContent() : "1.6", isThirdParty, modPackAttr.getNamedItem("minLaunchSpec") == null ? 0 : Integer.parseInt(modPackAttr.getNamedItem("minLaunchSpec").getTextContent()), modPackAttr.getNamedItem("warning") == null ? null : modPackAttr.getNamedItem("warning").getTextContent().replace("\\n", "\n"), modPackAttr.getNamedItem("customMCVersions") == null ? null : modPackAttr.getNamedItem("customMCVersions").getTextContent()));
                    continue;
                }
                catch (Exception e) {
                    Logger.logError("Error while updating modpack info", e);
                }
            }
            ModPack.addPacks(mp);
            try {
                modPackStream.close();
            }
            catch (IOException e) {}
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FTBPacksPane.getInstance().getPacksScroll().getViewport().setViewPosition(new Point(0, 0));
            }
        });
        Logger.logDebug("All packlists loaded");
        Benchmark.logBenchAs("ModpackLoader", "Modpack Loader Init");
        FTBPacksPane.getInstance().loaded = true;
        ThirdPartyPane.getInstance().loaded = true;
        LaunchFrame.checkDoneLoading();
        Map.loadAll();
        TexturePack.loadAll();
    }
}

